/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.css.core.model;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.css.core.model.ICSSMetadataElement;
import com.aptana.css.core.model.UserAgentElement;
import com.aptana.index.core.IndexDocument;
import com.aptana.index.core.IndexUtil;
import com.aptana.jetty.util.epl.ajax.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseElement
implements ICSSMetadataElement,
JSON.Convertible,
IndexDocument {
    private static final String USER_AGENTS_PROPERTY = "userAgents";
    private static final String EXAMPLE_PROPERTY = "example";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String NAME_PROPERTY = "name";
    private String _name;
    private List<UserAgentElement> _userAgents;
    private String _description;
    private String _example;
    private List<String> _documents;

    public void addDocument(String document) {
        if (!StringUtil.isEmpty((String)document)) {
            if (this._documents == null) {
                this._documents = new ArrayList<String>();
            }
            this._documents.add(document);
        }
    }

    public void addUserAgent(UserAgentElement userAgent) {
        if (userAgent != null) {
            if (this._userAgents == null) {
                this._userAgents = new ArrayList<UserAgentElement>();
            }
            this._userAgents.add(userAgent);
        }
    }

    public void fromJSON(Map object) {
        this.setName(StringUtil.getStringValue(object.get(NAME_PROPERTY)));
        this.setDescription(StringUtil.getStringValue(object.get(DESCRIPTION_PROPERTY)));
        this.setExample(StringUtil.getStringValue(object.get(EXAMPLE_PROPERTY)));
        this._userAgents = IndexUtil.createList(object.get(USER_AGENTS_PROPERTY), UserAgentElement.class);
    }

    @Override
    public String getDescription() {
        return StringUtil.getStringValue((Object)this._description);
    }

    public List<String> getDocuments() {
        return CollectionsUtil.getListValue(this._documents);
    }

    @Override
    public String getExample() {
        return StringUtil.getStringValue((Object)this._example);
    }

    @Override
    public String getName() {
        return StringUtil.getStringValue((Object)this._name);
    }

    @Override
    public List<String> getUserAgentNames() {
        List<UserAgentElement> userAgents = this.getUserAgents();
        ArrayList<String> result = new ArrayList<String>(userAgents.size());
        for (UserAgentElement ua : userAgents) {
            result.add(ua.getPlatform());
        }
        return result;
    }

    @Override
    public List<UserAgentElement> getUserAgents() {
        return CollectionsUtil.getListValue(this._userAgents);
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setExample(String example) {
        this._example = example;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void toJSON(JSON.Output out) {
        out.add(NAME_PROPERTY, (Object)this.getName());
        out.add(DESCRIPTION_PROPERTY, (Object)this.getDescription());
        out.add(EXAMPLE_PROPERTY, (Object)this.getExample());
        out.add(USER_AGENTS_PROPERTY, this.getUserAgents());
    }
}

